local screenName = Var("LoadingScreen");
local selectYes = THEME:GetMetric(screenName,"StartOnYes");
local saved = false
local showMessageAfterYes = THEME:GetMetric(screenName,"ShowMessageAfterYes");

local function genDlg(TEXTBOX_HEIGHT)
	if not TEXTBOX_HEIGHT then
		TEXTBOX_HEIGHT = 150;
	end
	
	return Def.ActorFrame{

		Def.Quad{ --Top
			InitCommand=cmd(setsize,SCREEN_WIDTH,2;diffuse,Color("White");fadeleft,.1;faderight,.1;diffusealpha,0;);
			PlayCommand=cmd(decelerate,.4;y,-(TEXTBOX_HEIGHT/2 - 10);diffusealpha,1);
			--PlayCommand=cmd(diffusealpha,0;decelerate,.2;diffusealpha,1);
			StopCommand=cmd(decelerate,.5;diffusealpha,0;y,0);
		};

		Def.Quad{ --Bottom
			InitCommand=cmd(setsize,SCREEN_WIDTH,2;diffuse,Color("White");fadeleft,.1;faderight,.1;diffusealpha,0;);
			PlayCommand=cmd(decelerate,.4;y,TEXTBOX_HEIGHT/2 - 10;diffusealpha,1);
			--PlayCommand=cmd(diffusealpha,0;decelerate,.2;diffusealpha,1);
			StopCommand=cmd(decelerate,.5;diffusealpha,0;y,0);
		};
		
		--For debugging, left and right
		--[[Def.Quad{
			InitCommand=cmd(setsize,2,TEXTBOX_HEIGHT;diffuse,Color("Red");addx,-350);
		};
		Def.Quad{
			InitCommand=cmd(setsize,2,TEXTBOX_HEIGHT;diffuse,Color("Red");addx,350);
		};]]
	};
end

local function afterYesFunction()

end;

local frame;
local function reeeeeeeeeeee(event)
	local pn= event.PlayerNumber
	local button = event.button
	if event.type ~= "InputEventType_FirstPress" then return end
	--SCREENMAN:SystemMessage(button);
	
	if saved then
		if button == "Start" then
			--frame:playcommand("Off")
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
			return;
		else
			return;
		end;
	end;
	if button == "Left" or button == "MenuLeft" or button=="DownLeft" then
		if not selectYes then
			SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			selectYes = true;
			frame:playcommand("UpdateSelection");
		end;
	elseif button == "Right" or button == "MenuRight" or button=="DownRight" then
		if selectYes then
			SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			selectYes = false;
			frame:playcommand("UpdateSelection");
		end;
	elseif button == "Center" or button == "Start" then
	
		SOUND:PlayOnce(THEME:GetPathS("Common", "Start"), true);
		if selectYes then
			frame:playcommand("Stop")
			if showMessageAfterYes then
				frame:sleep(1):queuecommand("Play");
				saved = true;
			else
				SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
			end;
		else
			frame:playcommand("Stop")
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
		end;
	else
		--SCREENMAN:SystemMessage("Unknown Button "..button);
	end;
end;

return Def.ActorFrame{
	InitCommand=cmd(Center);
	OnCommand=function(self)
		frame = self;
		SCREENMAN:GetTopScreen():AddInputCallback(reeeeeeeeeeee);
	end;
	
	--Def.Quad{ InitCommand=cmd(diffuse,Color.HoloBlue;setsize,SCREEN_WIDTH,SCREEN_HEIGHT); };
	
	genDlg(150)..{
		OnCommand=cmd(queuecommand,"Play");
		OffCommand=cmd(queuecommand,"Stop");
	};
	LoadFont("_ubuntu 20px")..{
		Text=THEME:GetString(Var('LoadingScreen'),"Prompt");
		InitCommand=cmd(diffusealpha,0;wrapwidthpixels,SCREEN_WIDTH-30);
		OnCommand=cmd(decelerate,.4;addy,-30;diffusealpha,1);
		StopCommand=cmd(decelerate,.4;y,0;diffusealpha,0);
	};
	LoadFont("_ubuntu Bold 35px")..{
		Text=THEME:GetString("OptionNames","Yes");
		InitCommand=cmd(x,-100;diffusealpha,0);
		OnCommand=cmd(decelerate,.4;addy,30;playcommand,"UpdateSelection");
		StopCommand=cmd(decelerate,.4;y,0;diffusealpha,0);
		UpdateSelectionCommand=function(self)
			if selectYes then
				self:diffuse(Color.White)
				self:diffuseshift():effectcolor1({1,1,1,1}):effectcolor2({1,1,1,.7})
			else
				self:stopeffect();
				self:diffuse({.5,.5,.5,.5})
			end;
		end;
	};
	LoadFont("_ubuntu Bold 35px")..{
		Text=THEME:GetString("OptionNames","No");
		InitCommand=cmd(x,100;diffuse,{0,0,0,0});
		OnCommand=cmd(decelerate,.4;addy,30;playcommand,"UpdateSelection");
		StopCommand=cmd(stoptweening;stopeffect;decelerate,.4;y,0;diffusealpha,0);
		UpdateSelectionCommand=function(self)
			if not selectYes then
				self:diffuse(Color.White)
				self:diffuseshift():effectcolor1({1,1,1,1}):effectcolor2({1,1,1,.7})
			else
				self:stopeffect();
				self:diffuse({.5,.5,.5,.5})
			end;
		end;
	};
	LoadFont("_ubuntu Bold 35px")..{
		Text=THEME:GetString("ScreenStorySavePrompt","AfterYesMessage");
		InitCommand=cmd(diffusealpha,0);
		PlayCommand=cmd(sleep,.1;linear,.3;diffusealpha,1);
		OffCommand=cmd(linear,.2;diffusealpha,0;sleep,.5);
	};
	
	
}
